#ifndef ddhundoabledivloop_H
#define ddhundoabledivloop_H
// added by little_penguin
#include <stdio.h>
#include <stdlib.h>
#include <algorithm>
//
#ifdef _WINDOWS
#define WINDOWS
#endif
#include "ac_plugin.h"
#include "Undoables.h"

// added by little_penguin
using namespace std;
//

//---------------------------------------------------------------------------------------
class DDHUndoableDivLoop : public Undoable
{

private:

   // Object + parent struct
   struct t_mObjectParent
   {
      ACObject *parent;
      ACObject *o;
   };

   // Whether the Undo was called
   bool mUndoCalled;
   // The select mode during the operation
   int mSelectMode;

   // The new selection
   List *mSelNew;
   // The old selection
   List *mSelOld;

   // List of "old" objects (pre-division)
   List *mObjsOld;
   // List of "new" objects (post-division)
   List *mObjsNew;

public:

   // Constructor
   DDHUndoableDivLoop();
   // Destructor
   ~DDHUndoableDivLoop();

   void execute();
   void undo();
   void redo();

};
//---------------------------------------------------------------------------------------
class DHSurfaceEdges
{
public:
   Surface *surface;
   List *edges;
   DHSurfaceEdges()
   {
      surface = NULL;
      edges = NULL;
   }
};
//---------------------------------------------------------------------------------------
static int sort_compare_dhsurfaceedges( const void *p1, const void *p2 )
{
   DHSurfaceEdges *a = ( DHSurfaceEdges * )p1;
   DHSurfaceEdges *b = ( DHSurfaceEdges * )p2;
   if( a->surface < b->surface )
   {
      return -1;
   }
   else if( a->surface > b->surface )
   {
      return 1;
   }
   return 0;
}
//---------------------------------------------------------------------------------------
class DHSurfaceEdgesList
{
public:
   DHSurfaceEdges *mData;
   int mCount;
   DHSurfaceEdgesList( List *surflist, int numsurfs )
   {
      mData = NULL;
      mCount = max( 0, numsurfs );
      if( mCount > 0 )
      {
         mData = new DHSurfaceEdges[mCount];
         int ctr = 0;
         for( List *ps = surflist; ps != NULL; ps = ps->next )
         {
            mData[ctr++].surface = ( Surface * )( ps->data );
         }
      }
   }
   ~DHSurfaceEdgesList()
   {
      if( mData != NULL )
      {
         delete[] mData;
      }
   }
   void Sort()
   {
      qsort(( void * )mData, mCount, sizeof( DHSurfaceEdges ), sort_compare_dhsurfaceedges );
   }
   int BSearch( Surface *s )
   {
      int low = 0;
      int high = mCount - 1;
      while( low <= high )
      {
         int mid = ( low + high ) / 2;
         if( s < mData[mid].surface )
         {
            high = mid - 1;
         }
         else if( s > mData[mid].surface )
         {
            low = mid + 1;
         }
         else
         {
            return mid;
         }
      }
      return -1;
   }
   void AddEdge( ACEdge *e )
   {
      for( List *ps = e->surfacelist; ps != NULL; ps = ps->next )
      {
         int idx = BSearch(( Surface * )( ps->data ));
         if( idx > -1 )
         {
            list_add_item_head( &( mData[idx].edges ), e );
         }
      }
   }
};
//---------------------------------------------------------------------------------------

#endif
