// added by little_penguin
#include <stdio.h>
#include <stdlib.h>
//
#include "dhlistsorted.h"

//---------------------------------------------------------------------------------------
int vcomp( const void *a, const void *b )
{
   if(( *( void ** )a ) < ( *( void ** )b ))
   {
      return -1;
   }
   else if(( *( void ** )a ) > ( *( void ** )b ))
   {
      return 1;
   }
   return 0;
}
//---------------------------------------------------------------------------------------
DHListSorted::DHListSorted( List *l )
{

   // Init
   mData = NULL;
   mTag = NULL;
   mCount = list_count( l );
   if( mCount < 1 )
   {
      return;
   }

   // Load the elements
   mData = new void*[mCount];
   int ctr = 0;
   for( List *pl = l; pl != NULL; pl = pl->next )
   {
      mData[ctr++] = pl->data;
   }

   // Create a tag list
   mTag = new int[mCount];
   for( int ix = 0; ix < mCount; ++ix )
   {
      mTag[ix] = 0;
   }

   // Sort the list
   qsort(( void * )mData, mCount, sizeof( void * ), vcomp );

}
//---------------------------------------------------------------------------------------
DHListSorted::~DHListSorted()
{
   if( mCount > 0 )
   {
      delete[] mData;
   }
}
//---------------------------------------------------------------------------------------
int DHListSorted::mSearch( void *key )
{
   int low = 0;
   int high = mCount - 1;
   while( low <= high )
   {
      int mid = ( low + high ) / 2;
      if( key < mData[mid] )
      {
         high = mid - 1;
      }
      else if( key > mData[mid] )
      {
         low = mid + 1;
      }
      else
      {
         return mid;
      }
   }
   return -1;
}
//---------------------------------------------------------------------------------------
