#include "dhobjectcopy.h"
#include "dhlistsorted.h"
#include <stdio.h>
// added by little_penguin
#include <stdlib.h>
//

//---------------------------------------------------------------------------------------
DHObjectCopy::DHObjectCopy( ACObject *o, bool obj_known_selected )
{
   mObject = NULL;
   mSurfaces = NULL;
   mVertices = NULL;
   CopyFrom( o, obj_known_selected );
}
//---------------------------------------------------------------------------------------
DHObjectCopy::~DHObjectCopy()
{
   Clear( false );
}
//---------------------------------------------------------------------------------------
void DHObjectCopy::Clear( bool delete_from_ac3d )
{
   if( delete_from_ac3d && object_exists( mObject ))
   {
      object_delete_nocleanup( mObject );
   }
   for( List *ps = mSurfaces; ps != NULL; ps = ps->next )
   {
      delete (( t_oc_surface * )( ps->data ));
   }
   for( List *pv = mVertices; pv != NULL; pv = pv->next )
   {
      delete (( t_oc_vertex * )( pv->data ));
   }
   list_free( &mSurfaces );
   list_free( &mVertices );
   mObject = NULL;
   mSurfaces = NULL;
   mVertices = NULL;
}
//---------------------------------------------------------------------------------------
void DHObjectCopy::CopyFrom( ACObject *o, bool obj_known_selected )
{

   Clear( false );

   // Grab a list of selected surfaces/vertices
   // or an indicator that this entire object is selected
   List *selsurfs = NULL;
   List *selverts = NULL;
   bool object_selected = false;
   switch( ac_get_select_mode() )
   {
   case SELECT_SURFACE:
      selsurfs = ac_selection_get_surfaces();
      selverts = ac_selection_get_vertices_all();
      break;
   case SELECT_VERTEX:
      selsurfs = ac_selection_get_whole_surfaces_all();
      selverts = ac_selection_get_vertices();
      break;
   case SELECT_GROUP:
      // If the object is not known to be selected, find out for ourselves
      object_selected = obj_known_selected;
      if( !object_selected )
      {
         List *selgrps = ac_selection_get_groups();
         List *selobjs = NULL;
         dh_get_objects_from_groups( &selobjs, selgrps );
         list_free( &selgrps );
         // Find this object in the list of selected objects
         for( List *po = selobjs; po != NULL; po = po->next )
         {
            if( o == (( ACObject * )( po->data )))
            {
               object_selected = true;
               break;
            }
         }
         list_free( &selobjs );
      }
      break;
   default:
      // If the object is not known to be selected, find out for ourselves
      object_selected = obj_known_selected;
      if( !object_selected )
      {
         List *selobjs = ac_selection_get_objects();
         // Find this object in the list of selected objects
         for( List *po = selobjs; po != NULL; po = po->next )
         {
            if( o == (( ACObject * )( po->data )))
            {
               object_selected = true;
               break;
            }
         }
         list_free( &selobjs );
      }
      break;
   }

   // Gather a sorted list of the selected vertices/surfaces
   DHListSorted *sorted_surfs = NULL;
   DHListSorted *sorted_verts = NULL;
   if( !object_selected )
   {
      sorted_surfs = new DHListSorted( selsurfs );
      sorted_verts = new DHListSorted( selverts );
      list_free( &selsurfs );
      list_free( &selverts );
   }

   // Duplicate the object
   mObject = ac_new_object();
   ac_object_set_crease_angle( mObject, ac_object_get_crease_angle( o ));
   ac_object_set_centre( mObject, ac_object_get_centre( o ));
   object_set_url( mObject, ac_object_get_url( o ));
   if( ac_object_get_data( o ) != NULL )
   {
      object_set_userdata( mObject, ac_object_get_data( o ));
   }
   if( ac_object_has_texture( o ))
   {
      object_texture_set( mObject, ac_object_get_texture_index( o ));
   }
   if( ac_object_is_subdivided( o ))
   {
      ac_object_set_subdivision_level( mObject, ac_object_get_subdivision_level( o ));
   }

   /*
   // Create the new object.
   // Do this by cloning and then removing all surfs/verts.
   // Seems wasteful, but this guarantees all object properties
   // (textures, user data, crease angle, etc) are properly copied.
   mObject = object_clone( o );
   List *tmp_list = list_clone( ac_object_get_surfacelist( mObject ));
   for( List *pv = tmp_list; pv != NULL; pv = pv->next )
   {
      object_delete_surface( mObject, ( Surface * )( pv->data ));
   }
   list_free( &tmp_list );
   tmp_list = list_clone( ac_object_get_vertexlist( mObject ));
   for( List *pv = tmp_list; pv != NULL; pv = pv->next )
   {
      object_delete_vertex( mObject, ( Vertex * )( pv->data ));
   }
   list_free( &tmp_list );
   */

   // Add the vertices
   for( List *pv = ac_object_get_vertexlist( o ); pv != NULL; pv = pv->next )
   {
      Vertex *v = ( Vertex * )( pv->data );
      t_oc_vertex *nv = new t_oc_vertex;
      nv->v_orig = v;
      nv->v = new_vertex_set( v->x, v->y, v->z );
      if( object_selected )
      {
         nv->selected = true;
      }
      else
      {
         nv->selected = ( sorted_verts->mSearch( v ) > -1 );
      }
      list_add_item_head( &mVertices, nv );
      object_add_vertex_head( mObject, nv->v );
   }

   // Add the surfaces
   for( List *ps = ac_object_get_surfacelist( o ); ps != NULL; ps = ps->next )
   {
      Surface *s = ( Surface * )( ps->data );
      t_oc_surface *ns = new t_oc_surface;
      ns->s_orig = s;
      ns->s = new_surface();
      surface_copy_properties( ns->s_orig, ns->s );
      for( List *psv = s->vertlist; psv != NULL; psv = psv->next )
      {
         SVertex *sv = ( SVertex * )( psv->data );
         // Find the original vertex, add the dupe
         for( List *pocv = mVertices; pocv != NULL; pocv = pocv->next )
         {
            t_oc_vertex *ocv = ( t_oc_vertex * )( pocv->data );
            if( ocv->v_orig == sv->v )
            {
               surface_add_vertex( ns->s, ocv->v, sv->tx, sv->ty );
               break;
            }
         }
      }
      if( object_selected )
      {
         ns->selected = true;
      }
      else
      {
         ns->selected = ( sorted_surfs->mSearch( s ) > -1 );
      }
      list_add_item_head( &mSurfaces, ns );
      object_add_surface_head( mObject, ns->s );
   }

   object_calc_normals_force( mObject );

   if( !object_selected )
   {
      delete sorted_surfs;
      delete sorted_verts;
   }

}
//---------------------------------------------------------------------------------------
