#ifndef dhobjectcopy_H
#define dhobjectcopy_H
//added by little_penguin
#include <stdio.h>
//
#ifdef _WINDOWS
#define WINDOWS
#endif
#include "ac_plugin.h"

//---------------------------------------------------------------------------------------
// Adds the children of an object/group to a list
static void dh_add_object_kids( List **outlist, ACObject *obj )
{
   for( List *po = ac_object_get_childrenlist( obj ); po != NULL; po = po->next )
   {
      ACObject *o = ( ACObject * )( po->data );
      if( ac_object_get_type( o ) == OBJECT_NORMAL )
      {
         list_add_item_head( outlist, o );
      }
      dh_add_object_kids( outlist, o );
   }
}
//---------------------------------------------------------------------------------------
// Gets a list of objects from a list of groups
static void dh_get_objects_from_groups( List **outlist, List *grplist )
{
   for( List *pg = grplist; pg != NULL; pg = pg->next )
   {
      ACObject *o = ( ACObject * )( pg->data );
      if( ac_object_get_type( o ) == OBJECT_NORMAL )
      {
         list_add_item_head( outlist, o );
      }
      dh_add_object_kids( outlist, o );
   }
}
//---------------------------------------------------------------------------------------
// Class for cloning ACObjects while keeping up with the select-state of surfaces/vertices
class DHObjectCopy
{

private:

   struct t_oc_vertex
   {
      Vertex *v_orig;
      Vertex *v;
      bool selected;
   };
   struct t_oc_surface
   {
      Surface *s_orig;
      Surface *s;
      bool selected;
   };

   // Copy from an ACObject
   void CopyFrom( ACObject *o, bool obj_known_selected );

public:

   // The cloned object
   ACObject *mObject;
   // The cloned object's surface list (includes select state)
   List *mSurfaces;
   // The cloned object's vertex list (includes select state)
   List *mVertices;

   // Constructor
   DHObjectCopy( ACObject *o, bool obj_known_selected );
   // Destructor
   ~DHObjectCopy();

   // Clear the cloned object data
   void Clear( bool delete_from_ac3d );

   // Get a list of selected surfaces
   void AppendSelectedSurfaces( List **outlist )
   {
      for( List *pp = mSurfaces; pp != NULL; pp = pp->next )
      {
         t_oc_surface *p = ( t_oc_surface * )( pp->data );
         if( p->selected )
         {
            list_add_item_head( outlist, p->s );
         }
      }
   }
   // Get a list of selected vertices
   void AppendSelectedVertices( List **outlist )
   {
      for( List *pp = mVertices; pp != NULL; pp = pp->next )
      {
         t_oc_vertex *p = ( t_oc_vertex * )( pp->data );
         if( p->selected )
         {
            list_add_item_head( outlist, p->v );
         }
      }
   }

};
//---------------------------------------------------------------------------------------

#endif
