proc ddh_axis_selector { name variable } {

   frame $name
   label $name.x -text "X" -relief raised -pady 0 -bd 1 
   label $name.y -text "Y" -relief raised -pady 0 -bd 1
   label $name.z -text "Z" -relief raised -pady 0 -bd 1

   bind $name.x <ButtonPress-1> "%W configure -relief sunken; $name.y configure -relief raised; $name.z configure -relief raised; uplevel #0 \"set $variable x\""
   bind $name.y <ButtonPress-1> "%W configure -relief sunken; $name.x configure -relief raised; $name.z configure -relief raised; uplevel #0 \"set $variable y\""
   bind $name.z <ButtonPress-1> "%W configure -relief sunken; $name.x configure -relief raised; $name.y configure -relief raised; uplevel #0 \"set $variable z\""
   pack $name.x $name.y $name.z -side left -padx 0

   return $name

}

proc ddhwave_makeframe {} {

   global ddhwave_axis_freq
   global ddhwave_axis_amp
   global ddhwave_amp
   global ddhwave_freq
   global ddhwave_offset
   global ddhwave_additive
   global ddhwave_frequnits

   set ddhwave_axis_freq        x
   set ddhwave_axis_amp         y
   set ddhwave_amp            0.1
   set ddhwave_freq             1
   set ddhwave_offset           0
   set ddhwave_additive         1
   set ddhwave_frequnits        0

   toplevel .ddhwave
   wm title .ddhwave "Wave"
   wm transient .ddhwave [winfo toplevel [winfo parent .ddhwave]]

   set width 6
   set ypad 3

   # Frequency axis
   frame .ddhwave.frmfreqa
   pack .ddhwave.frmfreqa -side top -fill x
   label .ddhwave.frmfreqa.lblaxisfreq -text "Frequency axis   "
   ddh_axis_selector .ddhwave.frmfreqa.axisfreq ddhwave_axis_freq
   pack .ddhwave.frmfreqa.lblaxisfreq -anchor w -side left
   pack .ddhwave.frmfreqa.axisfreq -anchor e -side right
   if { $ddhwave_axis_freq == "y" } {
      .ddhwave.frmfreqa.axisfreq.y configure -relief sunken
   } else {
      if { $ddhwave_axis_freq == "z" } {
         .ddhwave.frmfreqa.axisfreq.z configure -relief sunken
      } else {
         .ddhwave.frmfreqa.axisfreq.x configure -relief sunken
         set $ddhwave_axis_freq x
      }
   }

   # Amplitude axis
   frame .ddhwave.frmampa
   pack .ddhwave.frmampa -side top -fill x
   label .ddhwave.frmampa.lblaxisamp -text "Amplitude axis   "
   ddh_axis_selector .ddhwave.frmampa.axisamp ddhwave_axis_amp
   pack .ddhwave.frmampa.lblaxisamp -anchor w -side left
   pack .ddhwave.frmampa.axisamp -anchor e -side right
   if { $ddhwave_axis_amp == "y" } {
      .ddhwave.frmampa.axisamp.y configure -relief sunken
   } else {
      if { $ddhwave_axis_amp == "z" } {
         .ddhwave.frmampa.axisamp.z configure -relief sunken
      } else {
         .ddhwave.frmampa.axisamp.x configure -relief sunken
         set $ddhwave_axis_amp x
      }
   }

   # Space
   frame .ddhwave.frmspace0
   pack .ddhwave.frmspace0 -side top -fill x -pady $ypad

   # Frequency
   frame .ddhwave.frmfreq
   pack .ddhwave.frmfreq -side top -fill x
   label .ddhwave.frmfreq.lblfreq -text "Frequency   "
   spinbox .ddhwave.frmfreq.freq -from 0.0 -increment 0.1 -to 100.0 -textvariable ddhwave_freq -width $width
   pack .ddhwave.frmfreq.lblfreq -anchor w -side left
   pack .ddhwave.frmfreq.freq -anchor e -side right
   add_balloon .ddhwave.frmfreq.freq "Wave frequency"

   # Frequency type
   frame .ddhwave.frmfreqtype
   pack .ddhwave.frmfreqtype -side top -fill x
   checkbutton .ddhwave.frmfreqtype.chkfreqtype -text "Frequency expressed in units" -variable ddhwave_frequnits
   pack .ddhwave.frmfreqtype.chkfreqtype -anchor w
   add_balloon .ddhwave.frmfreqtype.chkfreqtype "Check to specify frequency in units.  If unchecked, frequency is the number of waveforms over the entire selection"

   # Space
   frame .ddhwave.frmspace0a
   pack .ddhwave.frmspace0a -side top -fill x -pady $ypad

   # Amplitude
   frame .ddhwave.frmamp
   pack .ddhwave.frmamp -side top -fill x
   label .ddhwave.frmamp.lblamp -text "Amplitude   "
   spinbox .ddhwave.frmamp.amp -from 0.0 -increment 0.01 -to 1000.0 -textvariable ddhwave_amp -width $width
   pack .ddhwave.frmamp.lblamp -anchor w -side left
   pack .ddhwave.frmamp.amp -anchor e -side right
   add_balloon .ddhwave.frmamp.amp "Amplitude (height) of wave"

   # Offset
   frame .ddhwave.frmoffset
   pack .ddhwave.frmoffset -side top -fill x
   label .ddhwave.frmoffset.lbloffset -text "Offset %   "
   spinbox .ddhwave.frmoffset.offset -from 0.0 -increment 0.5 -to 100.0 -textvariable ddhwave_offset -width $width
   pack .ddhwave.frmoffset.lbloffset -anchor w -side left
   pack .ddhwave.frmoffset.offset -anchor e -side right
   add_balloon .ddhwave.frmoffset.offset "Offset percentage to start wave"

   # Space
   frame .ddhwave.frmspace1
   pack .ddhwave.frmspace1 -side top -fill x -pady $ypad

   # Options
   frame .ddhwave.frmopts
   pack .ddhwave.frmopts -side top -fill x

   # Additive
   checkbutton .ddhwave.frmopts.chkadditive -text "Additive" -variable ddhwave_additive
   pack .ddhwave.frmopts.chkadditive -anchor w
   add_balloon .ddhwave.frmopts.chkadditive "Check to add values to existing coordinates.\nUncheck to reposition vertices completely to adhere to wave."

   # Space
   frame .ddhwave.frmspace2
   pack .ddhwave.frmspace2 -side top -fill x -pady $ypad

   # Apply waveform
   frame .ddhwave.frmbtn
   pack .ddhwave.frmbtn -side top -fill x

   button .ddhwave.frmbtn.btnapplyrand -text "Apply wave with random offset" -command {
      eval ac3d ddhwave_go $ddhwave_axis_freq $ddhwave_axis_amp $ddhwave_freq $ddhwave_amp "random" $ddhwave_additive $ddhwave_frequnits
   }
   pack .ddhwave.frmbtn.btnapplyrand -expand 1 -fill x
   button .ddhwave.frmbtn.btnapply -text "Apply wave" -command {
      eval ac3d ddhwave_go $ddhwave_axis_freq $ddhwave_axis_amp $ddhwave_freq $ddhwave_amp $ddhwave_offset $ddhwave_additive $ddhwave_frequnits
   }
   pack .ddhwave.frmbtn.btnapply -expand 1 -fill x

}

proc ddhwave_dialog {} {

   if ![winfo exists .ddhwave] {
      ddhwave_makeframe
   }

   wm deiconify .ddhwave
   centre_window_on_screen .ddhwave

}

